/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.rmi.MarshalledObject;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import sun.awt.Mutex;
import sun.awt.SunToolkit;
import sun.awt.windows.WDropTargetContextPeerFileStream;
import sun.awt.windows.WDropTargetContextPeerIStream;
import sun.awt.windows.WToolkit;

final class WDropTargetContextPeer
implements DropTargetContextPeer,
Transferable,
Runnable {
    private static final int DISPATCH_NONE = 0;
    private static final int DISPATCH_ENTER = 1;
    private static final int DISPATCH_MOTION = 2;
    private static final int DISPATCH_CHANGED = 3;
    private static final int DISPATCH_EXIT = 4;
    private static final int DISPATCH_DROP = 5;
    private static final Object _globalLock = new Object();
    private static Transferable currentJVMLocalSourceTransferable = null;
    private static AccessControlContext currentJVMLocalSourceACtxt = null;
    static final int STATUS_NONE = 0;
    static final int STATUS_WAIT = 1;
    static final int STATUS_ACCEPT = 2;
    static final int STATUS_REJECT = -1;
    private static WDropTargetContextPeer dropTargetContextPeer;
    private Component currentC;
    private DropTarget currentDT;
    private DropTargetContext currentDTC;
    private String[] currentT;
    private int currentA;
    private int currentDA;
    private int nativeDragContext;
    private Transferable local;
    private int messagePending = 0;
    private Component currentNC;
    private int currentX;
    private int currentY;
    private int currentSA;
    int dropStatus = 0;
    boolean dropComplete = false;
    Object lock = new Object();
    Mutex syncLock = new Mutex();
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;

    static void setCurrentJVMLocalSourceTransferable(Transferable transferable) throws InvalidDnDOperationException {
        Object object = _globalLock;
        synchronized (object) {
            if (transferable != null && currentJVMLocalSourceTransferable != null) {
                throw new InvalidDnDOperationException();
            }
            currentJVMLocalSourceTransferable = transferable;
            currentJVMLocalSourceACtxt = transferable != null ? AccessController.getContext() : null;
        }
    }

    static Transferable getJVMLocalSourceTransferable() {
        Transferable transferable = null;
        Object object = _globalLock;
        synchronized (object) {
            if (currentJVMLocalSourceTransferable != null && !currentJVMLocalSourceACtxt.equals(AccessController.getContext())) {
                AccessController.checkPermission(new AWTPermission("acceptDropBetweenAccessControllerContexts"));
            }
            transferable = currentJVMLocalSourceTransferable;
        }
        return transferable;
    }

    static WDropTargetContextPeer getWDropTargetContextPeer() {
        Object object = _globalLock;
        synchronized (object) {
            dropTargetContextPeer = new WDropTargetContextPeer();
        }
        return dropTargetContextPeer;
    }

    private static ByteArrayInputStream getMemoryStream(byte[] byArray, String string) {
        return new ByteArrayInputStream(byArray);
    }

    private static FileInputStream getFileStream(String string, String string2, int n) throws IOException {
        return new WDropTargetContextPeerFileStream(string, string2, n);
    }

    private static Object getIStream(int n, String string) throws IOException {
        return new WDropTargetContextPeerIStream(n, string);
    }

    private static List getList(Object[] objectArray) {
        return Arrays.asList(objectArray);
    }

    WDropTargetContextPeer() {
    }

    public DropTarget getDropTarget() {
        Object object = this.lock;
        synchronized (object) {
            DropTarget dropTarget = this.currentDT;
            return dropTarget;
        }
    }

    public void setTargetActions(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.currentA = n & 0x40000003;
        }
    }

    public int getTargetActions() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.currentA;
            return n;
        }
    }

    public void setAutoscrollInsets(Insets insets) {
    }

    public void setAutoscrollDelay(int n) {
    }

    public boolean doesPlatformImplementAutoscrolling() {
        return false;
    }

    public Transferable getTransferable() {
        return this;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        if (this.local != null) {
            dataFlavorArray = this.local.getTransferDataFlavors();
        } else {
            Object object = this.lock;
            synchronized (object) {
                Object[] objectArray = this.currentDT.getFlavorMap().getFlavorsForNatives(this.currentT).values().toArray();
                dataFlavorArray = new DataFlavor[objectArray.length];
                System.arraycopy(objectArray, 0, dataFlavorArray, 0, objectArray.length);
            }
        }
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (this.local != null) {
            return this.local.isDataFlavorSupported(dataFlavor);
        }
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException, InvalidDnDOperationException {
        Object object;
        if (this.local != null) {
            return this.local.getTransferData(dataFlavor);
        }
        String string = null;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.dropStatus != 2 || this.dropComplete) {
                throw new InvalidDnDOperationException("No drop current");
            }
            object = this.currentDT.getFlavorMap().getNativesForFlavors(new DataFlavor[]{dataFlavor});
            string = (String)object.get(dataFlavor);
            if (string == null) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            int n = 0;
            while (n < this.currentT.length) {
                if (this.currentT[n].equals(string)) break;
                ++n;
            }
            if (n == this.currentT.length) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
        object = this.getData(this.nativeDragContext, string);
        if (object == null) {
            throw new IOException("no native data was transferred");
        }
        if (object instanceof List) {
            return object;
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            Class clazz;
            if ((class$java$io$InputStream == null ? (class$java$io$InputStream = WDropTargetContextPeer.class$("java.io.InputStream")) : class$java$io$InputStream).equals(clazz = dataFlavor.getRepresentationClass())) {
                return (InputStream)object;
            }
            Constructor[] constructorArray = null;
            try {
                constructorArray = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazz.getConstructors();
                    }
                });
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                throw new IOException(securityException.getMessage());
            }
            Constructor constructor = null;
            int n = 0;
            while (n < constructorArray.length) {
                Class[] classArray;
                if (Modifier.isPublic(constructorArray[n].getModifiers()) && (classArray = constructorArray[n].getParameterTypes()) != null && classArray.length == 1 && (class$java$io$InputStream == null ? WDropTargetContextPeer.class$("java.io.InputStream") : class$java$io$InputStream).equals(classArray[0])) {
                    constructor = constructorArray[n];
                    break;
                }
                ++n;
            }
            if (constructor == null) {
                throw new InvalidDnDOperationException("cant find <init>(Ljava/io/InputStream;)V for class: " + clazz.getName());
            }
            try {
                return constructor.newInstance(new Object[]{(InputStream)object});
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidDnDOperationException(exception.getMessage());
            }
        }
        if (dataFlavor.isRepresentationClassRemote()) {
            if (this.currentDA != 0x40000000) {
                throw new InvalidDnDOperationException("only ACTION_LINK is permissable for transfer java.rmi.Remote objects");
            }
            try {
                InputStream inputStream = (InputStream)object;
                Object t = ((MarshalledObject)new ObjectInputStream(inputStream).readObject()).get();
                inputStream.close();
                return t;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidDnDOperationException(exception.getMessage());
            }
        }
        if (dataFlavor.isRepresentationClassSerializable()) {
            try {
                InputStream inputStream = (InputStream)object;
                Object object3 = new ObjectInputStream(inputStream).readObject();
                inputStream.close();
                return object3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidDnDOperationException(exception.getMessage());
            }
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = WDropTargetContextPeer.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
            try {
                InputStream inputStream = (InputStream)object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 0;
                byte[] byArray = new byte[64];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                return new String(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidDnDOperationException(exception.getMessage());
            }
        }
        throw new IOException("getTransferData() failed");
    }

    public boolean isTransferableJVMLocal() {
        return this.local != null || WDropTargetContextPeer.getJVMLocalSourceTransferable() != null;
    }

    public void run() {
        this.syncLock.lock();
        int n = this.messagePending;
        this.syncLock.unlock();
        switch (n) {
            case 1: {
                this.processEnterMessage();
                break;
            }
            case 2: 
            case 3: {
                this.processMotionMessage(n);
                break;
            }
            case 4: {
                this.processExitMessage();
                break;
            }
            case 5: {
                this.processDropMessage();
                return;
            }
        }
        this.syncLock.lock();
        if (this.messagePending != 0) {
            this.messagePending = 0;
            WToolkit.quitSecondaryEventLoop();
        }
        this.syncLock.unlock();
    }

    private int handleEnterMessage(Component component, int n, int n2, int n3, int n4, String[] stringArray, int n5) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            WToolkit.startSecondaryEventLoop();
            this.syncLock.lock();
        }
        this.nativeDragContext = n5;
        this.currentNC = component;
        this.currentT = stringArray;
        this.currentX = n;
        this.currentY = n2;
        this.currentSA = n4;
        this.currentDA = n3;
        this.messagePending = 1;
        SunToolkit.executeOnEventHandlerThread(component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            WToolkit.startSecondaryEventLoop();
            this.syncLock.lock();
        }
        int n6 = this.currentA;
        this.syncLock.unlock();
        return n6;
    }

    private void processEnterMessage() {
        boolean bl;
        Component component;
        DropTarget dropTarget = null;
        Point point = null;
        this.local = WDropTargetContextPeer.getJVMLocalSourceTransferable();
        Object object = this.currentNC.getTreeLock();
        synchronized (object) {
            try {
                component = this.findComponentAt((Container)this.currentNC, this.currentX, this.currentY);
            }
            catch (ClassCastException classCastException) {
                component = this.currentNC.locate(this.currentX, this.currentY);
            }
            boolean bl2 = bl = component != null && component.isShowing() && (dropTarget = component.getDropTarget()) != null && dropTarget.isActive();
            if (bl) {
                point = this.translate(this.currentNC, this.currentX, this.currentY, component);
            }
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
                this.currentDTC = null;
            }
        }
        if (bl) {
            Object object3 = this.lock;
            synchronized (object3) {
                this.currentC = component;
                this.currentDT = dropTarget;
                this.currentDTC = this.currentDT.getDropTargetContext();
                this.currentDTC.addNotify(this);
                this.currentA = dropTarget.getDefaultActions();
            }
            try {
                dropTarget.dragEnter(new DropTargetDragEvent(this.currentDTC, point, this.currentDA, this.currentSA));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object object4 = this.lock;
                synchronized (object4) {
                    this.currentA = 0;
                }
            }
        } else {
            Object object5 = this.lock;
            synchronized (object5) {
                this.currentDT = null;
                this.currentDTC = null;
                this.currentA = 0;
            }
        }
    }

    private void handleExitMessage(Component component, int n) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            WToolkit.startSecondaryEventLoop();
            this.syncLock.lock();
        }
        this.nativeDragContext = n;
        this.messagePending = 4;
        SunToolkit.executeOnEventHandlerThread(component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            WToolkit.startSecondaryEventLoop();
            this.syncLock.lock();
        }
        this.syncLock.unlock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processExitMessage() {
        Object object;
        DropTarget dropTarget = null;
        DropTargetContext dropTargetContext = null;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.currentC != null) {
                DropTarget dropTarget2 = this.currentC.getDropTarget();
                if (dropTarget2 == null) {
                    this.currentC = null;
                    this.currentDT = null;
                    this.currentT = null;
                    if (this.currentDTC != null) {
                        this.currentDTC.removeNotify();
                    }
                    this.currentDTC = null;
                    return;
                }
                if (dropTarget2 != this.currentDT) {
                    if (this.currentDTC != null) {
                        this.currentDTC.removeNotify();
                    }
                    dropTarget = this.currentDT = dropTarget2;
                    dropTargetContext = this.currentDTC = dropTarget2.getDropTargetContext();
                    this.currentDTC.addNotify(this);
                } else {
                    dropTarget = this.currentDT;
                    dropTargetContext = this.currentDTC;
                }
            }
        }
        if (dropTarget == null) return;
        if (!dropTarget.isActive()) return;
        try {
            try {
                dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var7_7 = null;
                Object object22 = this.lock;
                synchronized (object22) {
                    this.currentA = 0;
                    this.currentSA = 0;
                    this.currentDA = 0;
                    this.currentC = null;
                    this.currentDT = null;
                    this.currentT = null;
                    this.currentDTC.removeNotify();
                    this.currentDTC = null;
                    this.local = null;
                    return;
                }
            }
            Object var7_6 = null;
            object = this.lock;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Object object4 = this.lock;
            synchronized (object4) {
                this.currentA = 0;
                this.currentSA = 0;
                this.currentDA = 0;
                this.currentC = null;
                this.currentDT = null;
                this.currentT = null;
                this.currentDTC.removeNotify();
                this.currentDTC = null;
                this.local = null;
                throw throwable;
            }
        }
        synchronized (object) {
            this.currentA = 0;
            this.currentSA = 0;
            this.currentDA = 0;
            this.currentC = null;
            this.currentDT = null;
            this.currentT = null;
            this.currentDTC.removeNotify();
            this.currentDTC = null;
            this.local = null;
            return;
        }
    }

    private int handleMotionMessage(Component component, int n, int n2, int n3, int n4, String[] stringArray, int n5) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            WToolkit.startSecondaryEventLoop();
            this.syncLock.lock();
        }
        this.nativeDragContext = n5;
        this.currentNC = component;
        this.currentT = stringArray;
        this.currentX = n;
        this.currentY = n2;
        this.currentSA = n4;
        int n6 = this.currentDA;
        this.currentDA = n3;
        this.messagePending = n6 == this.currentDA ? 2 : 3;
        SunToolkit.executeOnEventHandlerThread(component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            WToolkit.startSecondaryEventLoop();
            this.syncLock.lock();
        }
        int n7 = this.currentA;
        this.syncLock.unlock();
        return n7;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processMotionMessage(int n) {
        Object object;
        DropTarget dropTarget2;
        DropTargetContext dropTargetContext;
        DropTarget dropTarget;
        boolean bl2;
        Point point2;
        Component component;
        block48: {
            Object object2;
            block49: {
                component = null;
                Point point = null;
                point2 = null;
                boolean bl = false;
                bl2 = false;
                dropTarget = null;
                dropTargetContext = null;
                dropTarget2 = null;
                if (this.currentC == null) break block48;
                boolean bl3 = false;
                object = this.currentNC.getTreeLock();
                synchronized (object) {
                    try {
                        component = this.findComponentAt((Container)this.currentNC, this.currentX, this.currentY);
                    }
                    catch (ClassCastException classCastException) {
                        component = this.currentNC.locate(this.currentX, this.currentY);
                    }
                    point = this.translate(this.currentNC, this.currentX, this.currentY, this.currentC);
                    bl3 = this.currentC.equals(component);
                    if (!bl3 && component != null) {
                        point2 = this.translate(this.currentNC, this.currentX, this.currentY, component);
                        bl2 = component.isShowing() && (dropTarget2 = component.getDropTarget()) != null && dropTarget2.isActive();
                    }
                    object2 = this.lock;
                    synchronized (object2) {
                        dropTarget = this.currentC.getDropTarget();
                        if (dropTarget == null) {
                            this.currentDTC.removeNotify();
                            this.currentC = null;
                            this.currentDTC = null;
                            this.currentT = null;
                        } else {
                            if (this.currentDT != dropTarget) {
                                if (this.currentDTC != null) {
                                    this.currentDTC.removeNotify();
                                }
                                this.currentDT = dropTarget;
                                this.currentDTC = null;
                            }
                            if ((dropTargetContext = this.currentDT.getDropTargetContext()) != this.currentDTC) {
                                if (this.currentDTC != null) {
                                    this.currentDTC.removeNotify();
                                }
                                this.currentDTC = dropTargetContext;
                                this.currentDTC.addNotify(this);
                            }
                            bl = this.currentC.isShowing() && dropTarget.isActive();
                        }
                        if (!bl) break block49;
                    }
                }
                if (!bl3) {
                    Object object3;
                    try {
                        try {
                            dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var16_19 = null;
                            Object object4 = this.lock;
                            synchronized (object4) {
                                this.currentDTC.removeNotify();
                                this.currentDTC = null;
                                this.currentC = null;
                                this.currentT = null;
                                this.currentA = 0;
                                break block48;
                            }
                        }
                        Object var16_18 = null;
                        object3 = this.lock;
                    }
                    catch (Throwable throwable) {
                        Object var16_20 = null;
                        Object object5 = this.lock;
                        synchronized (object5) {
                            this.currentDTC.removeNotify();
                            this.currentDTC = null;
                            this.currentC = null;
                            this.currentT = null;
                            this.currentA = 0;
                            throw throwable;
                        }
                    }
                    synchronized (object3) {
                        this.currentDTC.removeNotify();
                        this.currentDTC = null;
                        this.currentC = null;
                        this.currentT = null;
                        this.currentA = 0;
                        break block48;
                    }
                } else {
                    try {
                        try {
                            if (n == 2) {
                                dropTarget.dragOver(new DropTargetDragEvent(dropTargetContext, point, this.currentDA, this.currentSA));
                                return;
                            } else {
                                dropTarget.dropActionChanged(new DropTargetDragEvent(dropTargetContext, point, this.currentDA, this.currentSA));
                            }
                            return;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object object6 = this.lock;
                            synchronized (object6) {
                                this.currentA = 0;
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        return;
                    }
                }
            }
            object2 = this.lock;
            synchronized (object2) {
                this.currentA = 0;
            }
        }
        if (component == null) {
            Object object7 = this.currentNC.getTreeLock();
            synchronized (object7) {
                try {
                    component = this.findComponentAt((Container)this.currentNC, this.currentX, this.currentY);
                }
                catch (ClassCastException classCastException) {
                    component = this.currentNC.locate(this.currentX, this.currentY);
                }
                boolean bl = bl2 = component != null && component.isShowing() && (dropTarget2 = component.getDropTarget()) != null && dropTarget2.isActive();
                if (bl2) {
                    point2 = this.translate(this.currentNC, this.currentX, this.currentY, component);
                }
            }
        }
        if (!bl2) {
            object = this.lock;
            synchronized (object) {
                this.currentC = null;
                this.currentDT = null;
                this.currentDTC = null;
                this.currentA = 0;
                return;
            }
        }
        object = this.lock;
        synchronized (object) {
            this.currentC = component;
            dropTarget = this.currentDT = dropTarget2;
            dropTargetContext = this.currentDTC = dropTarget2.getDropTargetContext();
            this.currentDTC.addNotify(this);
            this.currentA = dropTarget2.getDefaultActions();
        }
        try {
            dropTarget.dragEnter(new DropTargetDragEvent(dropTargetContext, point2, this.currentDA, this.currentSA));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Object object7 = this.lock;
            synchronized (object7) {
                this.currentA = 0;
                return;
            }
        }
    }

    private void handleDropMessage(Component component, int n, int n2, int n3, int n4, String[] stringArray, int n5) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            WToolkit.startSecondaryEventLoop();
            this.syncLock.lock();
        }
        this.nativeDragContext = n5;
        this.currentNC = component;
        this.currentT = stringArray;
        this.currentX = n;
        this.currentY = n2;
        this.currentSA = n4;
        this.currentDA = n3;
        this.messagePending = 5;
        SunToolkit.executeOnEventHandlerThread(component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            WToolkit.startSecondaryEventLoop();
            this.syncLock.lock();
        }
        this.syncLock.unlock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processDropMessage() {
        Component component = null;
        Point point = null;
        boolean bl = false;
        DropTarget dropTarget = null;
        Object object = this.currentNC.getTreeLock();
        // MONITORENTER : object
        try {
            component = this.findComponentAt((Container)this.currentNC, this.currentX, this.currentY);
        }
        catch (ClassCastException classCastException) {
            component = this.currentNC.locate(this.currentX, this.currentY);
        }
        boolean bl2 = bl = component != null && component.isShowing() && (dropTarget = component.getDropTarget()) != null && dropTarget.isActive();
        if (bl) {
            point = this.translate(this.currentNC, this.currentX, this.currentY, component);
        }
        // MONITOREXIT : object
        Object object2 = this.lock;
        // MONITORENTER : object2
        this.dropStatus = 1;
        this.dropComplete = false;
        // MONITOREXIT : object2
        if (!bl) {
            this.rejectDrop();
            return;
        }
        boolean bl3 = false;
        Object object3 = this.lock;
        // MONITORENTER : object3
        this.currentC = component;
        this.currentDT = dropTarget;
        DropTargetContext dropTargetContext = dropTarget.getDropTargetContext();
        if (this.currentDTC != null) {
            this.currentDTC.removeNotify();
        }
        this.currentDTC = dropTargetContext;
        this.currentDTC.addNotify(this);
        // MONITOREXIT : object3
        Object object4 = _globalLock;
        // MONITORENTER : object4
        this.local = WDropTargetContextPeer.getJVMLocalSourceTransferable();
        if (this.local != null) {
            WDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
        }
        // MONITOREXIT : object4
        try {
            try {
                dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
                dropTarget.drop(new DropTargetDropEvent(dropTargetContext, point, this.currentDA, this.currentSA, this.local != null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl3 = true;
                Object var14_13 = null;
                Object object5 = this.lock;
                // MONITORENTER : object5
                if (this.dropStatus == 1 || bl3) {
                    this.rejectDrop();
                }
                // MONITOREXIT : object5
                return;
            }
            Object var14_12 = null;
            Object object6 = this.lock;
            // MONITORENTER : object6
            if (this.dropStatus == 1 || bl3) {
                this.rejectDrop();
            }
            // MONITOREXIT : object6
            return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            Object object7 = this.lock;
            // MONITORENTER : object7
            if (this.dropStatus == 1 || bl3) {
                this.rejectDrop();
            }
            // MONITOREXIT : object7
            throw throwable;
        }
    }

    public void acceptDrag(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDT == null) {
                throw new IllegalArgumentException("no drag pending");
            }
            this.currentA = this.mapOperation(this.currentDT, n);
        }
    }

    public void rejectDrag() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDT == null) {
                throw new IllegalArgumentException("no drag pending");
            }
            this.currentA = 0;
        }
    }

    public void acceptDrop(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("invalid acceptDrop() action");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus != 1) {
                throw new InvalidDnDOperationException("invalid acceptDrop()");
            }
            this.currentDA = this.currentA = this.mapOperation(this.currentDT, n & this.currentSA);
            this.dropStatus = 2;
            this.dropComplete = false;
            this.dropDispatched();
        }
    }

    public void rejectDrop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus != 1) {
                throw new InvalidDnDOperationException("invalid rejectDrop()");
            }
            this.dropStatus = -1;
        }
        this.dropComplete(false);
    }

    private int mapOperation(DropTarget dropTarget, int n) {
        int[] nArray = new int[]{2, 1, 0x40000000};
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if ((n & nArray[n3]) == nArray[n3]) {
                n2 = nArray[n3];
                break;
            }
            ++n3;
        }
        return n2;
    }

    public void dropComplete(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus == 0) {
                throw new InvalidDnDOperationException("No Drop pending");
            }
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentC = null;
            this.currentDT = null;
            this.currentDTC = null;
            this.currentT = null;
            this.currentA = 0;
            Object object2 = _globalLock;
            synchronized (object2) {
                currentJVMLocalSourceTransferable = null;
            }
            this.dropStatus = 0;
            this.dropComplete = true;
        }
        this.dropDispatched();
        this.dropDone(this.nativeDragContext, bl ? this.currentDA : 0);
        this.currentDA = 0;
        this.nativeDragContext = 0;
    }

    int getDropStatus() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.dropStatus;
            return n;
        }
    }

    private Point translate(Component component, int n, int n2, Component component2) {
        Component component3 = component2;
        int n3 = 0;
        int n4 = 0;
        while (!component3.equals(component)) {
            Point point = component3.getLocation();
            n3 += point.x;
            n4 += point.y;
            component3 = component3.getParent();
        }
        return new Point(n - n3, n2 - n4);
    }

    private void dropDispatched() {
        this.syncLock.lock();
        if (this.messagePending == 5) {
            this.messagePending = 0;
            WToolkit.quitSecondaryEventLoop();
        }
        this.syncLock.unlock();
    }

    private native Object getData(int var1, String var2);

    private native void dropDone(int var1, int var2);

    private native Component findComponentAt(Container var1, int var2, int var3);

    static native void Initialize();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

